capture log close
clear all
macro drop _all
cd "/Volumes/Mike2025/MC_CLIENTS/2025/AER 2025/Stata/Time Varying Models"
set more off

log using "Output/log/opfp-corr/anOPFPcorr3", replace text

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Opex Cost Function - Time-Varying Models
			OPFP correlations
Author:  Alice Giovani & Michael Cunningham
File:    anOPFPcorr3.do
Initial Date:    16-Jun-2025
Revised Date:	 4-Sep-2025

--------------------------------------------------------------------------*/
tempfile opfp1 effCD effTLG

* Multilateral Opex-PFP data

import excel using "Input/OPFP-comparison-7Aug2025.xlsx", clear sheet("OPFP") ///
	cellrange(A1:C235) firstrow case(l)
gen dnspN = 0
replace dnspN = 1 if dnsp == "EVO"
replace dnspN = 2 if dnsp == "AGD"
replace dnspN = 3 if dnsp == "CIT"
replace dnspN = 4 if dnsp == "END"
replace dnspN = 5 if dnsp == "ENX"
replace dnspN = 6 if dnsp == "ERG"
replace dnspN = 7 if dnsp == "ESS"
replace dnspN = 8 if dnsp == "JEN"
replace dnspN = 9 if dnsp == "PCR"
replace dnspN = 10 if dnsp == "SAP"	
replace dnspN = 11 if dnsp == "AND"	
replace dnspN = 12 if dnsp == "TND"	
replace dnspN = 13 if dnsp == "UED"
drop dnsp
rename dnspN dnsp		

sort year dnsp
by year: egen maxopfp = max(opfp) 

gen opfpeff = opfp / maxopfp
sort dnsp year
drop maxopfp
describe

export excel using "Output/xlsx/OPFPcorr3/opfpeff.xlsx", replace firstrow(var)
save `opfp1'	

*==============================================================================
*. 1. Standard Models
*==============================================================================

* Read data - Standard
*----------------------
import excel using "Input/OPFP-comparison-7Aug2025.xlsx", clear sheet("Standard") ///
	cellrange(A1:G235) firstrow 
gen dnspN = 0
replace dnspN = 1 if dnsp == "EVO"
replace dnspN = 2 if dnsp == "AGD"
replace dnspN = 3 if dnsp == "CIT"
replace dnspN = 4 if dnsp == "END"
replace dnspN = 5 if dnsp == "ENX"
replace dnspN = 6 if dnsp == "ERG"
replace dnspN = 7 if dnsp == "ESS"
replace dnspN = 8 if dnsp == "JEN"
replace dnspN = 9 if dnsp == "PCR"
replace dnspN = 10 if dnsp == "SAP"	
replace dnspN = 11 if dnsp == "AND"	
replace dnspN = 12 if dnsp == "TND"	
replace dnspN = 13 if dnsp == "UED"
drop dnsp
rename dnspN dnsp		

sort dnsp year
drop opfp

merge 1:1 dnsp year using `opfp1'

** Standard ABR24 SFA & LSE correlations with OPFP index
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfp
corr eff_sfatlg  opfp
corr eff_lsecd  opfp
corr eff_lsetlg  opfp


** Standard ABR24 SFA & LSE correlations with OPFP-based efficiency measure
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfpeff
corr eff_sfatlg  opfpeff
corr eff_lsecd  opfpeff
corr eff_lsetlg  opfpeff


*==============================================================================
*   2. SFA-BC95-JTT-HN Models
*==============================================================================

* Read data - SFA-BC95-JTT-HN
*------------------------------
import excel using "Output/xlsx/SFA-BC95-JTT-HN/SFA-BC95-JTT-HN-eff-long.xlsx", ///
	clear sheet("SFACD") cellrange(A1:C235) firstrow 
rename bc eff_sfacd
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effCD'

import excel using "Output/xlsx/SFA-BC95-JTT-HN/SFA-BC95-JTT-HN-eff-long.xlsx", ///
	clear sheet("SFATLG") cellrange(A1:C235) firstrow 
rename bc eff_sfatlg
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effTLG'

use `opfp1', clear
merge 1:1 dnsp year using `effCD'
drop _merge
merge 1:1 dnsp year using `effTLG'
describe

** BC95-JTT-HN correlations with OPFP index
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfp
corr eff_sfatlg  opfp

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	di "DNSP `i'"
	corr eff_sfacd  opfp   if dnsp == `i'
	corr eff_sfatlg  opfp  if dnsp == `i'
}

** BC95-JTT-HN correlations with OPFP-based efficiency measure
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfpeff
corr eff_sfatlg  opfpeff

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	di "DNSP `i'"
	corr eff_sfacd  opfpeff   if dnsp == `i'
	corr eff_sfatlg  opfpeff  if dnsp == `i'
}

*==============================================================================
*   3. Kumb90-JTT-HN Models
*==============================================================================

* Read data - Kumb90-JTT-HN
*------------------------------
import excel using "Output/xlsx/SFA-Kumb90-JTT-HN/SFA-Kumb90-JTT-HN-eff-long.xlsx", ///
	clear sheet("SFACD") cellrange(A1:C235) firstrow 
rename eff eff_sfacd
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effCD', replace

import excel using "Output/xlsx/SFA-Kumb90-JTT-HN/SFA-Kumb90-JTT-HN-eff-long.xlsx", ///
	clear sheet("SFATLG") cellrange(A1:C235) firstrow 
rename eff eff_sfatlg	
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effTLG', replace

use `opfp1', clear
merge 1:1 dnsp year using `effCD'
drop _merge
merge 1:1 dnsp year using `effTLG'
describe

** Kumb90-JTT-HN correlations with OPFP index
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfp
corr eff_sfatlg  opfp

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	di "DNSP `i'"
	corr eff_sfacd  opfp   if dnsp == `i'
	corr eff_sfatlg  opfp  if dnsp == `i'
}

** Kumb90-JTT-HN correlations with OPFP-based efficiency measure
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfpeff
corr eff_sfatlg  opfpeff

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	di "DNSP `i'"
	corr eff_sfacd  opfpeff   if dnsp == `i'
	corr eff_sfatlg  opfpeff  if dnsp == `i'
}

*==============================================================================
*   4. Kumb90-JTT-HN-GTC Models
*==============================================================================

* Read data - Kumb90-JTT-HN-GTC
*---------------------------------
import excel using "Output/xlsx/SFA-Kumb90-JTT-HN-GTC/SFA-Kumb90-JTT-HN-GTC-eff-long.xlsx", ///
	clear sheet("SFACD") cellrange(A1:C235) firstrow 
rename eff eff_sfacd
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effCD', replace

import excel using "Output/xlsx/SFA-Kumb90-JTT-HN-GTC/SFA-Kumb90-JTT-HN-GTC-eff-long.xlsx", ///
	clear sheet("SFATLG") cellrange(A1:C235) firstrow 
rename eff eff_sfatlg
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effTLG', replace

use `opfp1', clear
merge 1:1 dnsp year using `effCD'
drop _merge
merge 1:1 dnsp year using `effTLG'
describe

** Kumb90-JTT-HN-GTC correlations with OPFP index
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfp
corr eff_sfatlg  opfp

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	di "DNSP `i'"
	corr eff_sfacd  opfp   if dnsp == `i'
	corr eff_sfatlg  opfp  if dnsp == `i'
}

** Kumb90-JTT-HN-GTC correlations with OPFP-based efficiency measure
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfpeff
corr eff_sfatlg  opfpeff

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	di "DNSP `i'"
	corr eff_sfacd  opfpeff   if dnsp == `i'
	corr eff_sfatlg  opfpeff  if dnsp == `i'
}

*==============================================================================
*   5. Kumb90-AJTT-HN Models
*==============================================================================

* Read data - Kumb90-AJTT-HN
*------------------------------
import excel using "Output/xlsx/SFA-Kumb90-AJTT-HN/SFA-Kumb90-AJTT-HN-eff-long.xlsx", ///
	clear sheet("SFACD") cellrange(A1:C235) firstrow 
rename eff eff_sfacd
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effCD', replace

import excel using "Output/xlsx/SFA-Kumb90-AJTT-HN/SFA-Kumb90-AJTT-HN-eff-long.xlsx", ///
	clear sheet("SFATLG") cellrange(A1:C235) firstrow 
rename eff eff_sfatlg
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effTLG', replace

use `opfp1', clear
merge 1:1 dnsp year using `effCD'
drop _merge
merge 1:1 dnsp year using `effTLG'
describe

** Kumb90-AJTT-HN correlations with OPFP index
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfp
corr eff_sfatlg  opfp

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	di "DNSP `i'"
	corr eff_sfacd  opfp   if dnsp == `i'
	corr eff_sfatlg  opfp  if dnsp == `i'
}

** Kumb90-AJTT-HN correlations with OPFP-based efficiency measure
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfpeff
corr eff_sfatlg  opfpeff

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	di "DNSP `i'"
	corr eff_sfacd  opfpeff   if dnsp == `i'
	corr eff_sfatlg  opfpeff  if dnsp == `i'
}

*==============================================================================
*   6. Kumb90-AJTT-HN-GTC Models
*==============================================================================

* Read data - Kumb90-AJTT-HN-GTC
*----------------------------------
import excel using "Output/xlsx/SFA-Kumb90-AJTT-HN-GTC/SFA-Kumb90-AJTT-HN-GTC-eff-long.xlsx", ///
	clear sheet("SFACD") cellrange(A1:C235) firstrow 
rename eff eff_sfacd
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effCD', replace

import excel using "Output/xlsx/SFA-Kumb90-AJTT-HN-GTC/SFA-Kumb90-AJTT-HN-GTC-eff-long.xlsx", ///
	clear sheet("SFATLG") cellrange(A1:C235) firstrow 
rename eff eff_sfatlg	
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effTLG', replace

use `opfp1', clear
merge 1:1 dnsp year using `effCD'
drop _merge
merge 1:1 dnsp year using `effTLG'
describe

** Kumb90-AJTT-HN-GTC correlations with OPFP index
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfp
corr eff_sfatlg  opfp

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	di "DNSP `i'"
	corr eff_sfacd  opfp   if dnsp == `i'
	corr eff_sfatlg  opfp  if dnsp == `i'
}

** Kumb90-AJTT-HN-GTC correlations with OPFP-based efficiency measure
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfpeff
corr eff_sfatlg  opfpeff

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	di "DNSP `i'"
	corr eff_sfacd  opfpeff   if dnsp == `i'
	corr eff_sfatlg  opfpeff  if dnsp == `i'
}

*==============================================================================
*   7. LSE-ADTT Models
*==============================================================================

* Read data - LSE-ADTT
*----------------------------------
import excel using "Output/xlsx/LSE-ADTT/LSE-ADTT-Eff-long.xlsx", ///
	clear sheet("LSECD") cellrange(A1:C235) firstrow 
rename eff eff_sfacd
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effCD', replace

import excel using "Output/xlsx/LSE-ADTT/LSE-ADTT-Eff-long.xlsx", ///
	clear sheet("LSETLG") cellrange(A1:C235) firstrow 
rename eff eff_sfatlg
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effTLG', replace

use `opfp1', clear
merge 1:1 dnsp year using `effCD'
drop _merge
merge 1:1 dnsp year using `effTLG'
describe

** LSE-ADTT correlations with OPFP index
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfp
corr eff_sfatlg  opfp

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	di "DNSP `i'"
	corr eff_sfacd  opfp   if dnsp == `i'
	corr eff_sfatlg  opfp  if dnsp == `i'
}

** LSE-ADTT correlations with OPFP-based efficiency measure
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfpeff
corr eff_sfatlg  opfpeff

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	di "DNSP `i'"
	corr eff_sfacd  opfpeff   if dnsp == `i'
	corr eff_sfatlg  opfpeff  if dnsp == `i'
}

*==============================================================================
*   8. LSE-ADTT-GTC Models
*==============================================================================

* Read data - LSE-ADTT-GTC
*----------------------------------
import excel using "Output/xlsx/LSE-ADTT-GTC/LSE-ADTT-GTC-Eff-long.xlsx", ///
	clear sheet("LSECD") cellrange(A1:C235) firstrow 
rename eff eff_sfacd
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effCD', replace

import excel using "Output/xlsx/LSE-ADTT-GTC/LSE-ADTT-GTC-Eff-long.xlsx", ///
	clear sheet("LSETLG") cellrange(A1:C235) firstrow 
rename eff eff_sfatlg
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effTLG', replace

use `opfp1', clear
merge 1:1 dnsp year using `effCD'
drop _merge
merge 1:1 dnsp year using `effTLG'
describe

** LSE-ADTT-GTC correlations with OPFP index
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfp
corr eff_sfatlg  opfp

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	corr eff_sfacd  opfp   if dnsp == `i'
	corr eff_sfatlg  opfp  if dnsp == `i'
}

** LSE-ADTT-GTC correlations with OPFP-based efficiency measure
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfpeff
corr eff_sfatlg  opfpeff

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	corr eff_sfacd  opfpeff   if dnsp == `i'
	corr eff_sfatlg  opfpeff  if dnsp == `i'
}

*==============================================================================
*   9. LSE-AJTT Models
*==============================================================================

* Read data - LSE-AJTT
*----------------------------------
import excel using "Output/xlsx/LSE-AJTT/LSE-AJTT-Eff-long.xlsx", ///
	clear sheet("LSECD") cellrange(A1:C235) firstrow 
rename eff eff_sfacd
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effCD', replace

import excel using "Output/xlsx/LSE-AJTT/LSE-AJTT-Eff-long.xlsx", ///
	clear sheet("LSETLG") cellrange(A1:C235) firstrow 
rename eff eff_sfatlg
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effTLG', replace

use `opfp1', clear
merge 1:1 dnsp year using `effCD'
drop _merge
merge 1:1 dnsp year using `effTLG'
describe

** LSE-AJTT correlations with OPFP index
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfp
corr eff_sfatlg  opfp

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	corr eff_sfacd  opfp   if dnsp == `i'
	corr eff_sfatlg  opfp  if dnsp == `i'
}

** LSE-AJTT correlations with OPFP-based efficiency measure
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfpeff
corr eff_sfatlg  opfpeff

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	corr eff_sfacd  opfpeff   if dnsp == `i'
	corr eff_sfatlg  opfpeff  if dnsp == `i'
}

*==============================================================================
*   10. LSE-AJTT-GTC Models
*==============================================================================

* Read data - LSE-AJTT-GTC
*----------------------------------
import excel using "Output/xlsx/LSE-AJTT-GTC/LSE-AJTT-GTC-Eff-long.xlsx", ///
	clear sheet("LSECD") cellrange(A1:C235) firstrow 
rename eff eff_sfacd
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effCD', replace

import excel using "Output/xlsx/LSE-AJTT-GTC/LSE-AJTT-GTC-Eff-long.xlsx", ///
	clear sheet("LSETLG") cellrange(A1:C235) firstrow 
rename eff eff_sfatlg
gen dnsp = eiid - 1000	
drop eiid
sort dnsp year
save `effTLG', replace

use `opfp1', clear
merge 1:1 dnsp year using `effCD'
drop _merge
merge 1:1 dnsp year using `effTLG'
describe

** LSE-AJTT-GTC correlations with OPFP index
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfp
corr eff_sfatlg  opfp

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	di "DNSP `i'"
	corr eff_sfacd  opfp   if dnsp == `i'
	corr eff_sfatlg  opfp  if dnsp == `i'
}

** LSE-AJTT-GTC correlations with OPFP-based efficiency measure
*------------------------------------------------------------------------------

* Panel correlations
*-------------------
corr eff_sfacd  opfpeff
corr eff_sfatlg  opfpeff

* DNSP correlations
*-------------------
forvalues i = 1/13 {
	di "DNSP `i'"
	corr eff_sfacd  opfpeff   if dnsp == `i'
	corr eff_sfatlg  opfpeff  if dnsp == `i'
}




log close
exit
